/****** Object:  StoredProcedure [dbo].[usp_Get_Discharge_Intent]    Script Date: 03/22/2012 11:04:49 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_Get_Discharge_Intent]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_Get_Discharge_Intent]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		PII	
-- Create date: 24.10.2012
-- Description:	Get discharge intent.
-- =============================================
CREATE PROCEDURE [dbo].[usp_Get_Discharge_Intent] 
	@ID	INT = NULL,
	@DOMAIN_ID NVARCHAR(50) = NULL,
	@APPOINTMENT_DATE datetime = NULL,
	@VISTA_SITE_UID UNIQUEIDENTIFIER = NULL
AS
BEGIN
SET NOCOUNT ON
IF @ID IS NOT NULL
	BEGIN 	
		SELECT
			 [ID],
			 [DOMAIN_ID],
			 [PATIENT_UID],
			 [DATE_ENTERED],
			 [IS_ACTIVE],
			 [APPOINTMENT_DATE],
			 [VISTA_SITE_UID],
			 [HOSPITAL_LOCATION_UID],
			 [WARD_UID],
			 [STATUS]			
		FROM DISCHARGE_INT 
		WHERE ID = @ID AND DOMAIN_ID = @DOMAIN_ID
	END
ELSE
	BEGIN
		DECLARE @VISTA_SITE_ID INT	
		SELECT
			 [ID],
			 [DOMAIN_ID],
			 [PATIENT_UID],
			 [DATE_ENTERED],
			 [IS_ACTIVE],
			 [APPOINTMENT_DATE],
			 [VISTA_SITE_UID],
			 [HOSPITAL_LOCATION_UID],
			 [WARD_UID],
			 [STATUS]			
		FROM DISCHARGE_INT 
		WHERE DOMAIN_ID = @DOMAIN_ID AND APPOINTMENT_DATE = @APPOINTMENT_DATE AND VISTA_SITE_UID= @VISTA_SITE_UID			
	END
END
GO